<?xml version="1.0" encoding="UTF-8"?>
<!--Erstellt und generiert von Altova StyleVision Enterprise Edition 2015 rel. 3 (x64) - nähere Informationen siehe http://www.altova.com/de/stylevision-->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:altova="http://www.altova.com" xmlns:altova-xfi="http://www.altova.com/xslt-extensions/xbrl" xmlns:altovaext="http://www.altova.com/xslt-extensions" xmlns:array="http://www.w3.org/2005/xpath-functions/array" xmlns:clitype="clitype" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:invoice="http://www.forum-datenaustausch.ch/invoice" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:map="http://www.w3.org/2005/xpath-functions/map" xmlns:math="http://www.w3.org/2005/xpath-functions/math" xmlns:sps="http://www.altova.com/StyleVision/user-xpath-functions" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xenc="http://www.w3.org/2001/04/xmlenc#" xmlns:xff="http://www.xbrl.org/2010/function/formula" xmlns:xfi="http://www.xbrl.org/2008/function/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="#all">
	<xsl:output version="4.0" method="html" indent="no" encoding="UTF-8" use-character-maps="spaces" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
	<xsl:character-map name="spaces">
		<xsl:output-character character="&#160;" string="&amp;nbsp;"/>
	</xsl:character-map>
	<xsl:param name="altova:bGeneratingFromPxf" select="false()"/>
	<xsl:param name="SV_OutputFormat" select="'HTML'"/>
	<xsl:param name="SV_BaseOutputFileName" as="xs:string?">
		<xsl:sequence select="for $i in altovaext:get-base-output-uri(), $j in tokenize( $i, &apos;[/\\]&apos; )[last()] return replace( $j, &apos;\.[^\.\s#%;]*$&apos;, &apos;&apos; )" use-when="function-available(&apos;altovaext:get-base-output-uri&apos;)"/>
	</xsl:param>
	<xsl:param name="SV_GeneratedFileNamePrefix" select="if ( $SV_BaseOutputFileName ) then $SV_BaseOutputFileName else &apos;RechnungsantwortStyleVision&apos;" as="xs:string?"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:decimal-format name="format1" grouping-separator=" " decimal-separator=","/>
	
	<xsl:variable name="altova:CssImages" select="()"/>
	<xsl:template match="/">
		<xsl:call-template name="altova:Root"/>
	</xsl:template>
	<xsl:template name="altova:Root">
		<html>
			<head>
				<title/>
				<meta name="generator" content="Altova StyleVision Enterprise Edition 2015 rel. 3 (x64) (http://www.altova.com)"/>
				<meta http-equiv="X-UA-Compatible" content="IE=7"/>
				<style type="text/css">
					<xsl:comment>h1 { margin-bottom:0;
 }
 h2 { margin-bottom:0;
 }
 h3 { margin-bottom:0;
 }</xsl:comment>
				</style>
				<xsl:comment>[if IE]&gt;&lt;STYLE type=&quot;text/css&quot;&gt;.altova-rotate-left-textbox{filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3)} .altova-rotate-right-textbox{filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=1)} &lt;/STYLE&gt;&lt;![endif]</xsl:comment>
				<xsl:comment>[if !IE]&gt;&lt;!</xsl:comment>
				<style type="text/css">.altova-rotate-left-textbox{-webkit-transform: rotate(-90deg) translate(-100%, 0%); -webkit-transform-origin: 0% 0%;-moz-transform: rotate(-90deg) translate(-100%, 0%); -moz-transform-origin: 0% 0%;-ms-transform: rotate(-90deg) translate(-100%, 0%); -ms-transform-origin: 0% 0%;}.altova-rotate-right-textbox{-webkit-transform: rotate(90deg) translate(0%, -100%); -webkit-transform-origin: 0% 0%;-moz-transform: rotate(90deg) translate(0%, -100%); -moz-transform-origin: 0% 0%;-ms-transform: rotate(90deg) translate(0%, -100%); -ms-transform-origin: 0% 0%;}</style>
				<xsl:comment>&lt;![endif]</xsl:comment>
				<style type="text/css">@page { margin-left:0.60in; margin-right:0.60in; margin-top:0.79in; margin-bottom:0.79in } @media print { br.altova-page-break { page-break-before: always; } }</style>
			</head>
			<body>
				<h1>
					<span style="font-weight:bold; ">
						<xsl:text>Rechnungsantwort</xsl:text>
					</span>
				</h1>
				<xsl:variable name="altova:table">
					<table border="0" width="100%">
						<xsl:variable name="altova:CurrContextGrid_0" select="."/>
						<xsl:variable name="altova:ColumnData"/>
						<tbody>
							<tr>
								<td style="width:4.41in; " valign="top" width="50%">
									<span>
										<xsl:text>Rechnungsnummer: </xsl:text>
									</span>
									<xsl:for-each select="$XML">
										<xsl:for-each select="invoice:response">
											<xsl:for-each select="invoice:payload">
												<xsl:for-each select="invoice:invoice">
													<xsl:for-each select="@request_id">
														<span style="font-weight:bold; ">
															<xsl:value-of select="string(.)"/>
														</span>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
									<br/>
									<span>
										<xsl:text>Rechnungsdatum: </xsl:text>
									</span>
									<xsl:for-each select="$XML">
										<xsl:for-each select="invoice:response">
											<xsl:for-each select="invoice:payload">
												<xsl:for-each select="invoice:invoice">
													<xsl:for-each select="@request_date">
														<span style="font-weight:bold; ">
															<xsl:variable name="altova:seqContentStrings_1">
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00', 'format1')"/>
																<xsl:variable name="sText" as="xs:string?">
																	<xsl:text>. </xsl:text>
																</xsl:variable>
																<xsl:value-of select="$sText"/>
																<xsl:variable name="sText" as="xs:string?">
																	<xsl:call-template name="DateToMonthName">
																		<xsl:with-param name="sDate" select="string(string(.))"/>
																		<xsl:with-param name="sFormat" select="'long'"/>
																	</xsl:call-template>
																</xsl:variable>
																<xsl:value-of select="$sText"/>
																<xsl:variable name="sText" as="xs:string?">
																	<xsl:text> </xsl:text>
																</xsl:variable>
																<xsl:value-of select="$sText"/>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000', 'format1')"/>
																<xsl:variable name="sText" as="xs:string?">
																	<xsl:text>, </xsl:text>
																</xsl:variable>
																<xsl:value-of select="$sText"/>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 12, 2)), '00', 'format1')"/>
																<xsl:variable name="sText" as="xs:string?">
																	<xsl:text>:</xsl:text>
																</xsl:variable>
																<xsl:value-of select="$sText"/>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 15, 2)), '00', 'format1')"/>
																<xsl:variable name="sText" as="xs:string?">
																	<xsl:text>:</xsl:text>
																</xsl:variable>
																<xsl:value-of select="$sText"/>
																<xsl:choose>
																	<xsl:when test="contains(string(string(.)), 'Z')">
																		<xsl:value-of select="format-number(number(substring-after(substring-after(substring-before(string(string(.)), 'Z'), ':'), ':')), '00', 'format1')"/>
																	</xsl:when>
																	<xsl:when test="contains(string(string(.)), '+')">
																		<xsl:value-of select="format-number(number(substring-after(substring-after(substring-before(string(string(.)), '+'), ':'), ':')), '00', 'format1')"/>
																	</xsl:when>
																	<xsl:when test="contains(substring(string(string(.)), 18), '-')">
																		<xsl:value-of select="format-number(number(substring-before(substring(string(string(.)), 18), '-')), '00', 'format1')"/>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 18)), '00', 'format1')"/>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:variable>
															<xsl:variable name="altova:sContent_1" select="string($altova:seqContentStrings_1)"/>
															<xsl:value-of select="$altova:sContent_1"/>
														</span>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</td>
								<td valign="top">
									<xsl:if test="exists(invoice:response/invoice:payload/invoice:reminder)">
										<span>
											<xsl:text>Mahnung: </xsl:text>
										</span>
										<xsl:for-each select="$XML">
											<xsl:for-each select="invoice:response">
												<xsl:for-each select="invoice:payload">
													<xsl:for-each select="invoice:reminder">
														<xsl:for-each select="@request_id">
															<span style="font-weight:bold; ">
																<xsl:value-of select="string(.)"/>
															</span>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
										<br/>
										<span>
											<xsl:text>Mahndatum: </xsl:text>
										</span>
										<xsl:for-each select="$XML">
											<xsl:for-each select="invoice:response">
												<xsl:for-each select="invoice:payload">
													<xsl:for-each select="invoice:reminder">
														<xsl:for-each select="@request_date">
															<span style="font-weight:bold; ">
																<xsl:variable name="altova:seqContentStrings_2">
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00', 'format1')"/>
																	<xsl:variable name="sText" as="xs:string?">
																		<xsl:text>. </xsl:text>
																	</xsl:variable>
																	<xsl:value-of select="$sText"/>
																	<xsl:variable name="sText" as="xs:string?">
																		<xsl:call-template name="DateToMonthName">
																			<xsl:with-param name="sDate" select="string(string(.))"/>
																			<xsl:with-param name="sFormat" select="'long'"/>
																		</xsl:call-template>
																	</xsl:variable>
																	<xsl:value-of select="$sText"/>
																	<xsl:variable name="sText" as="xs:string?">
																		<xsl:text> </xsl:text>
																	</xsl:variable>
																	<xsl:value-of select="$sText"/>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000', 'format1')"/>
																	<xsl:variable name="sText" as="xs:string?">
																		<xsl:text>, </xsl:text>
																	</xsl:variable>
																	<xsl:value-of select="$sText"/>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 12, 2)), '00', 'format1')"/>
																	<xsl:variable name="sText" as="xs:string?">
																		<xsl:text>:</xsl:text>
																	</xsl:variable>
																	<xsl:value-of select="$sText"/>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 15, 2)), '00', 'format1')"/>
																	<xsl:variable name="sText" as="xs:string?">
																		<xsl:text>:</xsl:text>
																	</xsl:variable>
																	<xsl:value-of select="$sText"/>
																	<xsl:choose>
																		<xsl:when test="contains(string(string(.)), 'Z')">
																			<xsl:value-of select="format-number(number(substring-after(substring-after(substring-before(string(string(.)), 'Z'), ':'), ':')), '00', 'format1')"/>
																		</xsl:when>
																		<xsl:when test="contains(string(string(.)), '+')">
																			<xsl:value-of select="format-number(number(substring-after(substring-after(substring-before(string(string(.)), '+'), ':'), ':')), '00', 'format1')"/>
																		</xsl:when>
																		<xsl:when test="contains(substring(string(string(.)), 18), '-')">
																			<xsl:value-of select="format-number(number(substring-before(substring(string(string(.)), 18), '-')), '00', 'format1')"/>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 18)), '00', 'format1')"/>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:variable>
																<xsl:variable name="altova:sContent_2" select="string($altova:seqContentStrings_2)"/>
																<xsl:value-of select="$altova:sContent_2"/>
															</span>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
										<br/>
										<span>
											<xsl:text>Mahnstufe: </xsl:text>
										</span>
										<xsl:for-each select="$XML">
											<xsl:for-each select="invoice:response">
												<xsl:for-each select="invoice:payload">
													<xsl:for-each select="invoice:reminder">
														<xsl:for-each select="@reminder_level">
															<span style="font-weight:bold; ">
																<xsl:value-of select="string(.)"/>
															</span>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:if>
									<br/>
								</td>
							</tr>
						</tbody>
					</table>
				</xsl:variable>
				<xsl:variable name="altova:col-count" select="sum( for $altova:cell in $altova:table/table/(thead | tbody | tfoot)[ 1 ]/tr[ 1 ]/(th | td) return altova:col-span( $altova:cell ) )"/>
				<xsl:variable name="altova:TableIndexInfo" select="altova:BuildTableIndexInfo($altova:table)"/>
				<xsl:variable name="altova:generate-cols" as="xs:boolean*" select="for $altova:pos in 1 to $altova:col-count return true()"/>
				<xsl:variable name="altova:nodeTableWithoutUnwantedParts">
					<xsl:apply-templates select="$altova:table" mode="altova:generate-table">
						<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
						<xsl:with-param name="altova:TableIndexInfo" select="$altova:TableIndexInfo"/>
					</xsl:apply-templates>
				</xsl:variable>
				<xsl:sequence select="$altova:nodeTableWithoutUnwantedParts"/>
				<xsl:if test="exists( invoice:response/invoice:payload/invoice:body/invoice:pending )">
					<xsl:for-each select="$XML">
						<xsl:for-each select="invoice:response">
							<xsl:for-each select="invoice:payload">
								<xsl:for-each select="invoice:body">
									<xsl:for-each select="invoice:pending">
										<xsl:call-template name="PendingState"/>
									</xsl:for-each>
								</xsl:for-each>
							</xsl:for-each>
						</xsl:for-each>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="exists( invoice:response/invoice:payload/invoice:body/invoice:accepted )">
					<xsl:for-each select="$XML">
						<xsl:for-each select="invoice:response">
							<xsl:for-each select="invoice:payload">
								<xsl:for-each select="invoice:body">
									<xsl:for-each select="invoice:accepted">
										<xsl:call-template name="AcceptedState"/>
									</xsl:for-each>
								</xsl:for-each>
							</xsl:for-each>
						</xsl:for-each>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="exists( invoice:response/invoice:payload/invoice:body/invoice:rejected )">
					<xsl:for-each select="$XML">
						<xsl:for-each select="invoice:response">
							<xsl:for-each select="invoice:payload">
								<xsl:for-each select="invoice:body">
									<xsl:for-each select="invoice:rejected">
										<xsl:call-template name="RejectedState"/>
									</xsl:for-each>
								</xsl:for-each>
							</xsl:for-each>
						</xsl:for-each>
					</xsl:for-each>
				</xsl:if>
				<span>
					<xsl:text>Therapeut: </xsl:text>
				</span>
				<span style="font-weight:bold; ">
					<xsl:text>GLN </xsl:text>
				</span>
				<xsl:for-each select="$XML">
					<xsl:for-each select="invoice:response">
						<xsl:for-each select="invoice:payload">
							<xsl:for-each select="invoice:body">
								<xsl:for-each select="invoice:provider">
									<xsl:for-each select="@ean_party">
										<span style="font-weight:bold; ">
											<xsl:value-of select="string(.)"/>
										</span>
									</xsl:for-each>
								</xsl:for-each>
							</xsl:for-each>
						</xsl:for-each>
					</xsl:for-each>
				</xsl:for-each>
				<br/>
				<span>
					<xsl:text>Versicherung: </xsl:text>
				</span>
				<span style="font-weight:bold; ">
					<xsl:text>GLN </xsl:text>
				</span>
				<xsl:for-each select="$XML">
					<xsl:for-each select="invoice:response">
						<xsl:for-each select="invoice:payload">
							<xsl:for-each select="invoice:body">
								<xsl:for-each select="invoice:insurance">
									<xsl:for-each select="@ean_party">
										<span style="font-weight:bold; ">
											<xsl:value-of select="string(.)"/>
										</span>
									</xsl:for-each>
								</xsl:for-each>
							</xsl:for-each>
						</xsl:for-each>
					</xsl:for-each>
				</xsl:for-each>
				<h2>
					<span>
						<xsl:text>Patient</xsl:text>
					</span>
				</h2>
				<xsl:variable name="altova:table">
					<table border="1" cellpadding="0" cellspacing="0" width="100%">
						<xsl:variable name="altova:CurrContextGrid_3" select="."/>
						<xsl:variable name="altova:ColumnData"/>
						<tbody>
							<tr>
								<td style="width:3.52in; " valign="top">
									<xsl:for-each select="$XML">
										<xsl:for-each select="invoice:response">
											<xsl:for-each select="invoice:payload">
												<xsl:for-each select="invoice:body">
													<xsl:for-each select="invoice:patient">
														<xsl:for-each select="invoice:person">
															<xsl:call-template name="Person_Adresse"/>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
									<br/>
								</td>
								<td valign="top">
									<span>
										<xsl:text>Geburtstag: </xsl:text>
									</span>
									<xsl:for-each select="$XML">
										<xsl:for-each select="invoice:response">
											<xsl:for-each select="invoice:payload">
												<xsl:for-each select="invoice:body">
													<xsl:for-each select="invoice:patient">
														<xsl:for-each select="@birthdate">
															<span>
																<xsl:variable name="altova:seqContentStrings_4">
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00', 'format1')"/>
																	<xsl:variable name="sText" as="xs:string?">
																		<xsl:text>. </xsl:text>
																	</xsl:variable>
																	<xsl:value-of select="$sText"/>
																	<xsl:variable name="sText" as="xs:string?">
																		<xsl:call-template name="DateToMonthName">
																			<xsl:with-param name="sDate" select="string(string(.))"/>
																			<xsl:with-param name="sFormat" select="'long'"/>
																		</xsl:call-template>
																	</xsl:variable>
																	<xsl:value-of select="$sText"/>
																	<xsl:variable name="sText" as="xs:string?">
																		<xsl:text> </xsl:text>
																	</xsl:variable>
																	<xsl:value-of select="$sText"/>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000', 'format1')"/>
																</xsl:variable>
																<xsl:variable name="altova:sContent_4" select="string($altova:seqContentStrings_4)"/>
																<xsl:value-of select="$altova:sContent_4"/>
															</span>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
									<br/>
									<span>
										<xsl:text>AHV-Nummer: </xsl:text>
									</span>
									<xsl:for-each select="$XML">
										<xsl:for-each select="invoice:response">
											<xsl:for-each select="invoice:payload">
												<xsl:for-each select="invoice:body">
													<xsl:for-each select="invoice:patient">
														<xsl:for-each select="@ssn">
															<span>
																<xsl:value-of select="string(.)"/>
															</span>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</td>
							</tr>
						</tbody>
					</table>
				</xsl:variable>
				<xsl:variable name="altova:col-count" select="sum( for $altova:cell in $altova:table/table/(thead | tbody | tfoot)[ 1 ]/tr[ 1 ]/(th | td) return altova:col-span( $altova:cell ) )"/>
				<xsl:variable name="altova:TableIndexInfo" select="altova:BuildTableIndexInfo($altova:table)"/>
				<xsl:variable name="altova:generate-cols" as="xs:boolean*" select="for $altova:pos in 1 to $altova:col-count return true()"/>
				<xsl:variable name="altova:nodeTableWithoutUnwantedParts">
					<xsl:apply-templates select="$altova:table" mode="altova:generate-table">
						<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
						<xsl:with-param name="altova:TableIndexInfo" select="$altova:TableIndexInfo"/>
					</xsl:apply-templates>
				</xsl:variable>
				<xsl:sequence select="$altova:nodeTableWithoutUnwantedParts"/>
				<h2>
					<span>
						<xsl:text>Kontakt</xsl:text>
					</span>
				</h2>
				<xsl:variable name="altova:table">
					<table border="1" cellpadding="0" cellspacing="0" width="100%">
						<xsl:variable name="altova:CurrContextGrid_5" select="."/>
						<xsl:variable name="altova:ColumnData"/>
						<tbody>
							<tr>
								<td style="width:3.51in; ">
									<span style="font-weight:bold; ">
										<xsl:text>Firma</xsl:text>
									</span>
								</td>
								<td style="width:3.56in; ">
									<span style="font-weight:bold; ">
										<xsl:text>Mitarbeiter</xsl:text>
									</span>
								</td>
								<td>
									<span style="font-weight:bold; ">
										<xsl:text>Person</xsl:text>
									</span>
								</td>
							</tr>
							<tr>
								<td style="width:3.51in; " valign="top">
									<span>
										<xsl:text>GLN: </xsl:text>
									</span>
									<xsl:for-each select="$XML">
										<xsl:for-each select="invoice:response">
											<xsl:for-each select="invoice:payload">
												<xsl:for-each select="invoice:body">
													<xsl:for-each select="invoice:contact">
														<xsl:for-each select="@ean_party">
															<span>
																<xsl:value-of select="string(.)"/>
															</span>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
									<xsl:if test="exists(invoice:response/invoice:payload/invoice:body/invoice:contact/invoice:company)">
										<xsl:for-each select="$XML">
											<xsl:for-each select="invoice:response">
												<xsl:for-each select="invoice:payload">
													<xsl:for-each select="invoice:body">
														<xsl:for-each select="invoice:contact">
															<xsl:for-each select="invoice:company">
																<xsl:call-template name="Person_Adresse"/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:if>
								</td>
								<td style="width:3.56in; " valign="top">
									<xsl:if test="exists(invoice:response/invoice:payload/invoice:body/invoice:contact/invoice:employee)">
										<xsl:for-each select="$XML">
											<xsl:for-each select="invoice:response">
												<xsl:for-each select="invoice:payload">
													<xsl:for-each select="invoice:body">
														<xsl:for-each select="invoice:contact">
															<xsl:for-each select="invoice:employee">
																<xsl:call-template name="Person_Adresse"/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:if>
								</td>
								<td valign="top">
									<xsl:if test="exists(invoice:response/invoice:payload/invoice:body/invoice:contact/invoice:person)">
										<xsl:for-each select="$XML">
											<xsl:for-each select="invoice:response">
												<xsl:for-each select="invoice:payload">
													<xsl:for-each select="invoice:body">
														<xsl:for-each select="invoice:contact">
															<xsl:for-each select="invoice:person">
																<xsl:call-template name="Person_Adresse"/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:if>
								</td>
							</tr>
						</tbody>
					</table>
				</xsl:variable>
				<xsl:variable name="altova:col-count" select="sum( for $altova:cell in $altova:table/table/(thead | tbody | tfoot)[ 1 ]/tr[ 1 ]/(th | td) return altova:col-span( $altova:cell ) )"/>
				<xsl:variable name="altova:TableIndexInfo" select="altova:BuildTableIndexInfo($altova:table)"/>
				<xsl:variable name="altova:generate-cols" as="xs:boolean*" select="for $altova:pos in 1 to $altova:col-count return true()"/>
				<xsl:variable name="altova:nodeTableWithoutUnwantedParts">
					<xsl:apply-templates select="$altova:table" mode="altova:generate-table">
						<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
						<xsl:with-param name="altova:TableIndexInfo" select="$altova:TableIndexInfo"/>
					</xsl:apply-templates>
				</xsl:variable>
				<xsl:sequence select="$altova:nodeTableWithoutUnwantedParts"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="DateToMonthName">
		<xsl:param name="sDate"/>
		<xsl:param name="sFormat"/>
		<xsl:choose>
			<xsl:when test="$sFormat = 'long'">
				<xsl:call-template name="DateToMonthNameLong">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="DateToMonthNameShort">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameLong">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">Januar</xsl:when>
			<xsl:when test="$nMonth = 2">Februar</xsl:when>
			<xsl:when test="$nMonth = 3">März</xsl:when>
			<xsl:when test="$nMonth = 4">April</xsl:when>
			<xsl:when test="$nMonth = 5">Mai</xsl:when>
			<xsl:when test="$nMonth = 6">Juni</xsl:when>
			<xsl:when test="$nMonth = 7">Juli</xsl:when>
			<xsl:when test="$nMonth = 8">August</xsl:when>
			<xsl:when test="$nMonth = 9">September</xsl:when>
			<xsl:when test="$nMonth = 10">Oktober</xsl:when>
			<xsl:when test="$nMonth = 11">November</xsl:when>
			<xsl:otherwise>Dezember</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNum">
		<xsl:param name="sDate"/>
		<xsl:choose>
			<xsl:when test="starts-with($sDate, '--')">
				<xsl:value-of select="number(substring($sDate, 3, 2))"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="number(substring($sDate, 6, 2))"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameShort">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">Jan</xsl:when>
			<xsl:when test="$nMonth = 2">Feb</xsl:when>
			<xsl:when test="$nMonth = 3">Mrz</xsl:when>
			<xsl:when test="$nMonth = 4">Apr</xsl:when>
			<xsl:when test="$nMonth = 5">Mai</xsl:when>
			<xsl:when test="$nMonth = 6">Jun</xsl:when>
			<xsl:when test="$nMonth = 7">Jul</xsl:when>
			<xsl:when test="$nMonth = 8">Aug</xsl:when>
			<xsl:when test="$nMonth = 9">Sep</xsl:when>
			<xsl:when test="$nMonth = 10">Okt</xsl:when>
			<xsl:when test="$nMonth = 11">Nov</xsl:when>
			<xsl:otherwise>Dez</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Person_Adresse">
		<xsl:param name="Person" as="xs:string" select="&apos;&apos;"/>
		<xsl:variable name="altova:table">
			<table border="0" width="100%" altova:hide-rows="empty">
				<xsl:variable name="altova:CurrContextGrid_6" select="."/>
				<xsl:variable name="altova:ColumnData"/>
				<tbody>
					<tr>
						<td>
							<xsl:if test="exists(invoice:companyname)">
								<xsl:for-each select="invoice:companyname">
									<xsl:apply-templates/>
								</xsl:for-each>
							</xsl:if>
						</td>
					</tr>
					<tr>
						<td>
							<xsl:if test="exists(invoice:department)">
								<xsl:for-each select="invoice:department">
									<xsl:apply-templates/>
								</xsl:for-each>
							</xsl:if>
						</td>
					</tr>
					<tr>
						<td>
							<xsl:for-each select="@salutation">
								<span>
									<xsl:value-of select="string(.)"/>
								</span>
							</xsl:for-each>
						</td>
					</tr>
					<tr>
						<td>
							<xsl:for-each select="@title">
								<span>
									<xsl:value-of select="string(.)"/>
								</span>
							</xsl:for-each>
						</td>
					</tr>
					<tr>
						<td>
							<xsl:if test="exists(invoice:familyname)">
								<xsl:for-each select="invoice:familyname">
									<xsl:apply-templates/>
								</xsl:for-each>
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
								<xsl:for-each select="invoice:givenname">
									<xsl:apply-templates/>
								</xsl:for-each>
							</xsl:if>
						</td>
					</tr>
					<tr>
						<td>
							<xsl:for-each select="invoice:subaddressing">
								<xsl:apply-templates/>
							</xsl:for-each>
						</td>
					</tr>
					<tr>
						<td>
							<xsl:for-each select="invoice:postal">
								<xsl:for-each select="invoice:pobox">
									<xsl:apply-templates/>
								</xsl:for-each>
							</xsl:for-each>
						</td>
					</tr>
					<tr>
						<td>
							<xsl:for-each select="invoice:postal">
								<xsl:for-each select="invoice:street">
									<xsl:apply-templates/>
								</xsl:for-each>
							</xsl:for-each>
						</td>
					</tr>
					<tr>
						<td>
							<xsl:if test="exists(invoice:postal)">
								<xsl:for-each select="invoice:postal">
									<xsl:for-each select="invoice:zip">
										<xsl:apply-templates/>
									</xsl:for-each>
								</xsl:for-each>
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
								<xsl:for-each select="invoice:postal">
									<xsl:for-each select="invoice:city">
										<xsl:apply-templates/>
									</xsl:for-each>
								</xsl:for-each>
							</xsl:if>
						</td>
					</tr>
					<tr>
						<td>
							<xsl:if test="exists(invoice:telecom/invoice:phone)">
								<span>
									<xsl:text>Tel: </xsl:text>
								</span>
								<xsl:for-each select="invoice:telecom">
									<xsl:for-each select="invoice:phone">
										<xsl:apply-templates/>
									</xsl:for-each>
								</xsl:for-each>
							</xsl:if>
						</td>
					</tr>
					<tr>
						<td>
							<xsl:if test="exists(invoice:telecom/invoice:fax)">
								<span>
									<xsl:text>Fax: </xsl:text>
								</span>
								<xsl:for-each select="invoice:telecom">
									<xsl:for-each select="invoice:fax">
										<xsl:apply-templates/>
									</xsl:for-each>
								</xsl:for-each>
							</xsl:if>
						</td>
					</tr>
					<tr>
						<td>
							<xsl:if test="exists(invoice:online/invoice:email)">
								<span>
									<xsl:text>E-Mail: </xsl:text>
								</span>
								<xsl:for-each select="invoice:online">
									<xsl:for-each select="invoice:email">
										<xsl:apply-templates/>
									</xsl:for-each>
								</xsl:for-each>
							</xsl:if>
						</td>
					</tr>
					<tr>
						<td>
							<xsl:if test="exists(invoice:online/invoice:url)">
								<span>
									<xsl:text>URL: </xsl:text>
								</span>
								<xsl:for-each select="invoice:online">
									<xsl:for-each select="invoice:url">
										<xsl:apply-templates/>
									</xsl:for-each>
								</xsl:for-each>
							</xsl:if>
						</td>
					</tr>
				</tbody>
			</table>
		</xsl:variable>
		<xsl:variable name="altova:col-count" select="sum( for $altova:cell in $altova:table/table/(thead | tbody | tfoot)[ 1 ]/tr[ 1 ]/(th | td) return altova:col-span( $altova:cell ) )"/>
		<xsl:variable name="altova:TableIndexInfo" select="altova:BuildTableIndexInfo($altova:table)"/>
		<xsl:variable name="altova:generate-cols" as="xs:boolean*" select="for $altova:pos in 1 to $altova:col-count return true()"/>
		<xsl:variable name="altova:nodeTableWithoutUnwantedParts">
			<xsl:apply-templates select="$altova:table" mode="altova:generate-table">
				<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
				<xsl:with-param name="altova:TableIndexInfo" select="$altova:TableIndexInfo"/>
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:sequence select="$altova:nodeTableWithoutUnwantedParts"/>
	</xsl:template>
	<xsl:template name="PendingState">
		<xsl:param name="Pending" as="xs:string*" select="&apos;&apos;"/>
		<span>
			<xsl:text>Status: </xsl:text>
		</span>
		<xsl:for-each select="@status_out">
			<xsl:choose>
				<xsl:when test=". = &apos;canceled&apos;">
					<span style="font-weight:bold; ">
						<xsl:text>Annulliert</xsl:text>
					</span>
				</xsl:when>
				<xsl:when test=". = &apos;claimed&apos;">
					<span style="font-weight:bold; ">
						<xsl:text>Abgeholt</xsl:text>
					</span>
				</xsl:when>
				<xsl:when test=". = &apos;frozen&apos;">
					<span style="font-weight:bold; ">
						<xsl:text>Eingefrohren</xsl:text>
					</span>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		<xsl:if test="exists(invoice:explanation)">
			<br/>
			<span>
				<xsl:text>Grund: </xsl:text>
			</span>
			<xsl:for-each select="invoice:explanation">
				<span style="background-color:#ffc0a0; font-weight:bold; ">
					<xsl:apply-templates/>
				</span>
			</xsl:for-each>
		</xsl:if>
		<br/>
		<xsl:variable name="altova:table">
			<table border="1" cellpadding="0" cellspacing="0" width="100%">
				<xsl:variable name="altova:CurrContextGrid_7" select="."/>
				<xsl:variable name="altova:ColumnData"/>
				<thead>
					<tr>
						<th style="text-align:left; width:1.28in; ">
							<span style="font-weight:bold; ">
								<xsl:text>Code</xsl:text>
							</span>
						</th>
						<th style="text-align:left; ">
							<span style="font-weight:bold; ">
								<xsl:text>Text</xsl:text>
							</span>
						</th>
					</tr>
				</thead>
				<tbody>
					<xsl:for-each select="invoice:message">
						<tr bgcolor="#ffc0a0">
							<td style="width:1.28in; " valign="top">
								<xsl:for-each select="@code">
									<span>
										<xsl:value-of select="string(.)"/>
									</span>
								</xsl:for-each>
							</td>
							<td>
								<xsl:for-each select="@text">
									<span>
										<xsl:value-of select="string(.)"/>
									</span>
								</xsl:for-each>
							</td>
						</tr>
					</xsl:for-each>
				</tbody>
			</table>
		</xsl:variable>
		<xsl:variable name="altova:col-count" select="sum( for $altova:cell in $altova:table/table/(thead | tbody | tfoot)[ 1 ]/tr[ 1 ]/(th | td) return altova:col-span( $altova:cell ) )"/>
		<xsl:variable name="altova:TableIndexInfo" select="altova:BuildTableIndexInfo($altova:table)"/>
		<xsl:variable name="altova:generate-cols" as="xs:boolean*" select="for $altova:pos in 1 to $altova:col-count return true()"/>
		<xsl:variable name="altova:nodeTableWithoutUnwantedParts">
			<xsl:apply-templates select="$altova:table" mode="altova:generate-table">
				<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
				<xsl:with-param name="altova:TableIndexInfo" select="$altova:TableIndexInfo"/>
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:sequence select="$altova:nodeTableWithoutUnwantedParts"/>
	</xsl:template>
	<xsl:template name="AcceptedState">
		<xsl:param name="Accepted" as="xs:string*" select="&apos;&apos;"/>
		<span>
			<xsl:text>Status: </xsl:text>
		</span>
		<xsl:for-each select="@status_out">
			<xsl:choose>
				<xsl:when test=". = &apos;canceled&apos;">
					<span style="font-weight:bold; ">
						<xsl:text>Annulliert</xsl:text>
					</span>
				</xsl:when>
				<xsl:when test=". = &apos;claimed&apos;">
					<span style="font-weight:bold; ">
						<xsl:text>Abgeholt</xsl:text>
					</span>
				</xsl:when>
				<xsl:when test=". = &apos;frozen&apos;">
					<span style="font-weight:bold; ">
						<xsl:text>Eingefrohren</xsl:text>
					</span>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		<xsl:if test="exists(invoice:explanation)">
			<br/>
			<span>
				<xsl:text>Grund: </xsl:text>
			</span>
			<xsl:for-each select="invoice:explanation">
				<span style="background-color:#ffc0a0; font-weight:bold; ">
					<xsl:apply-templates/>
				</span>
			</xsl:for-each>
		</xsl:if>
		<br/>
		<xsl:if test="exists(invoice:reimbursement)">
			<h3>
				<span style="font-weight:bold; ">
					<xsl:text>Rückvergütungsparameter</xsl:text>
				</span>
			</h3>
			<span>
				<xsl:text>Überweisener Betrag: </xsl:text>
			</span>
			<xsl:for-each select="invoice:reimbursement">
				<xsl:for-each select="invoice:balance">
					<xsl:for-each select="@amount_due">
						<span style="font-weight:bold; ">
							<xsl:value-of select="string(.)"/>
						</span>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:for-each>
			<br/>
			<xsl:if test="exists(invoice:reimbursement/invoice:esr9/@reference_number)">
				<span>
					<xsl:text>ESR-Referenznummer: </xsl:text>
				</span>
				<xsl:for-each select="invoice:reimbursement">
					<xsl:for-each select="invoice:esr9">
						<xsl:for-each select="@reference_number">
							<span style="font-weight:bold; ">
								<xsl:value-of select="string(.)"/>
							</span>
						</xsl:for-each>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:if>
			<br/>
			<xsl:variable name="altova:table">
				<table border="1" cellpadding="0" cellspacing="0" width="100%">
					<xsl:variable name="altova:CurrContextGrid_8" select="."/>
					<xsl:variable name="altova:ColumnData"/>
					<tbody>
						<tr>
							<td style="width:3.20in; ">
								<span style="font-weight:bold; ">
									<xsl:text>Debitor</xsl:text>
								</span>
							</td>
							<td style="width:3.43in; ">
								<span style="font-weight:bold; ">
									<xsl:text>Kreditor</xsl:text>
								</span>
							</td>
							<td>
								<span style="font-weight:bold; ">
									<xsl:text>Bank</xsl:text>
								</span>
							</td>
						</tr>
						<tr style="height:1.54in; " valign="top">
							<td style="width:3.20in; " valign="top">
								<xsl:for-each select="invoice:reimbursement">
									<xsl:for-each select="invoice:debitor">
										<xsl:for-each select="invoice:company">
											<xsl:call-template name="Person_Adresse"/>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:for-each>
								<br/>
							</td>
							<td style="width:3.43in; " valign="top">
								<xsl:for-each select="invoice:reimbursement">
									<xsl:for-each select="invoice:creditor">
										<xsl:for-each select="invoice:company">
											<xsl:call-template name="Person_Adresse"/>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:for-each>
								<br/>
							</td>
							<td>
								<xsl:for-each select="invoice:reimbursement">
									<xsl:for-each select="invoice:esr9">
										<xsl:for-each select="invoice:bank">
											<xsl:for-each select="invoice:company">
												<xsl:call-template name="Person_Adresse"/>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:for-each>
								<br/>
							</td>
						</tr>
					</tbody>
				</table>
			</xsl:variable>
			<xsl:variable name="altova:col-count" select="sum( for $altova:cell in $altova:table/table/(thead | tbody | tfoot)[ 1 ]/tr[ 1 ]/(th | td) return altova:col-span( $altova:cell ) )"/>
			<xsl:variable name="altova:TableIndexInfo" select="altova:BuildTableIndexInfo($altova:table)"/>
			<xsl:variable name="altova:generate-cols" as="xs:boolean*" select="for $altova:pos in 1 to $altova:col-count return true()"/>
			<xsl:variable name="altova:nodeTableWithoutUnwantedParts">
				<xsl:apply-templates select="$altova:table" mode="altova:generate-table">
					<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
					<xsl:with-param name="altova:TableIndexInfo" select="$altova:TableIndexInfo"/>
				</xsl:apply-templates>
			</xsl:variable>
			<xsl:sequence select="$altova:nodeTableWithoutUnwantedParts"/>
		</xsl:if>
		<br/>
	</xsl:template>
	<xsl:template name="RejectedState">
		<xsl:param name="Rejected" as="xs:string*" select="&apos;&apos;"/>
		<span>
			<xsl:text>Status: </xsl:text>
		</span>
		<xsl:for-each select="@status_out">
			<xsl:choose>
				<xsl:when test=". = &apos;canceled&apos;">
					<span style="font-weight:bold; ">
						<xsl:text>Annulliert</xsl:text>
					</span>
				</xsl:when>
				<xsl:when test=". = &apos;claimed&apos;">
					<span style="font-weight:bold; ">
						<xsl:text>Abgeholt</xsl:text>
					</span>
				</xsl:when>
				<xsl:when test=". = &apos;frozen&apos;">
					<span style="font-weight:bold; ">
						<xsl:text>Eingefrohren</xsl:text>
					</span>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		<xsl:if test="exists(invoice:explanation)">
			<br/>
			<span>
				<xsl:text>Grund: </xsl:text>
			</span>
			<xsl:for-each select="invoice:explanation">
				<span style="background-color:#ffc0a0; font-weight:bold; ">
					<xsl:apply-templates/>
				</span>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="exists(invoice:error)">
			<xsl:variable name="altova:table">
				<table border="1" cellpadding="0" cellspacing="0" width="100%" altova:hide-cols="body-empty">
					<xsl:variable name="altova:CurrContextGrid_9" select="."/>
					<xsl:variable name="altova:ColumnData"/>
					<thead>
						<tr style="height:0.22in; ">
							<th style="text-align:left; width:1.10in; ">
								<span style="font-weight:bold; ">
									<xsl:text>Code</xsl:text>
								</span>
							</th>
							<th style="text-align:left; width:5.99in; ">
								<span style="font-weight:bold; ">
									<xsl:text>Begründung</xsl:text>
								</span>
							</th>
							<th style="text-align:left; width:1.17in; ">
								<span style="font-weight:bold; ">
									<xsl:text>Falscher Wert</xsl:text>
								</span>
							</th>
							<th style="text-align:left; width:1.20in; ">
								<span style="font-weight:bold; ">
									<xsl:text>Korrekter Wert</xsl:text>
								</span>
							</th>
							<th style="text-align:left; ">
								<span style="font-weight:bold; ">
									<xsl:text>Rechnungsposition</xsl:text>
								</span>
							</th>
						</tr>
					</thead>
					<tbody>
						<xsl:for-each select="invoice:error">
							<tr bgcolor="#ffc0a0">
								<td style="text-align:left; width:1.10in; ">
									<xsl:for-each select="@code">
										<span>
											<xsl:value-of select="string(.)"/>
										</span>
									</xsl:for-each>
								</td>
								<td style="text-align:left; width:5.99in; ">
									<xsl:for-each select="@text">
										<span>
											<xsl:value-of select="string(.)"/>
										</span>
									</xsl:for-each>
								</td>
								<td style="text-align:left; width:1.17in; ">
									<xsl:if test="exists(invoice:error_value)">
										<xsl:for-each select="@error_value">
											<span>
												<xsl:value-of select="string(.)"/>
											</span>
										</xsl:for-each>
									</xsl:if>
								</td>
								<td style="text-align:left; width:1.20in; ">
									<xsl:if test="exists(invoice:valid_value)">
										<xsl:for-each select="@valid_value">
											<span>
												<xsl:value-of select="string(.)"/>
											</span>
										</xsl:for-each>
									</xsl:if>
								</td>
								<td style="text-align:left; ">
									<xsl:if test="exists(invoice:record_id)">
										<xsl:for-each select="@record_id">
											<span>
												<xsl:value-of select="string(.)"/>
											</span>
										</xsl:for-each>
									</xsl:if>
								</td>
							</tr>
						</xsl:for-each>
					</tbody>
				</table>
			</xsl:variable>
			<xsl:variable name="altova:col-count" select="sum( for $altova:cell in $altova:table/table/(thead | tbody | tfoot)[ 1 ]/tr[ 1 ]/(th | td) return altova:col-span( $altova:cell ) )"/>
			<xsl:variable name="altova:TableIndexInfo" select="altova:BuildTableIndexInfo($altova:table)"/>
			<xsl:variable name="altova:generate-cols" as="xs:boolean*">
				<xsl:choose>
					<xsl:when test="$altova:table/table/@altova:hide-cols = 'empty'">
						<xsl:sequence select="for $altova:pos in 1 to $altova:col-count return some $altova:cell in $altova:table/table/(thead | tbody | tfoot)/tr/(th | td )[ altova:col-position(., $altova:TableIndexInfo) = $altova:pos ] satisfies not( altova:is-cell-empty( $altova:cell ) )"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:sequence select="for $altova:pos in 1 to $altova:col-count return not( exists( $altova:table/table/tbody/tr/td[ altova:col-position(., $altova:TableIndexInfo) = $altova:pos ] ) ) or ( some $altova:cell in $altova:table/table/tbody/tr/td[ altova:col-position(., $altova:TableIndexInfo) = $altova:pos ] satisfies not( altova:is-cell-empty( $altova:cell ) ) )"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="altova:nodeTableWithoutUnwantedParts">
				<xsl:apply-templates select="$altova:table" mode="altova:generate-table">
					<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
					<xsl:with-param name="altova:TableIndexInfo" select="$altova:TableIndexInfo"/>
				</xsl:apply-templates>
			</xsl:variable>
			<xsl:sequence select="$altova:nodeTableWithoutUnwantedParts"/>
		</xsl:if>
		<br/>
		<br/>
	</xsl:template>
	<xsl:function name="altova:is-cell-empty" as="xs:boolean">
		<xsl:param name="altova:cell" as="element()"/>
		<xsl:sequence select="altova:is-node-empty( $altova:cell )"/>
	</xsl:function>
	<xsl:function name="altova:is-node-empty" as="xs:boolean">
		<xsl:param name="altova:node" as="element()"/>
		<xsl:sequence select="every $altova:child in $altova:node/child::node() satisfies ( ( boolean( $altova:child/self::text() ) and string-length( $altova:child ) = 0 ) or ( ( boolean( $altova:child/self::div ) or boolean( $altova:child/self::span ) or boolean( $altova:child/self::a ) ) and altova:is-node-empty( $altova:child ) ) )"/>
	</xsl:function>
	<xsl:function name="altova:col-position" as="xs:integer">
		<xsl:param name="altova:Cell" as="element()"/>
		<xsl:param name="altova:TableIndexInfo" as="element()"/>
		<xsl:variable name="altova:nRow" select="altova:GetGridRowNumForCell($altova:Cell)"/>
		<xsl:variable name="altova:nCell" select="count($altova:Cell/(preceding-sibling::th | preceding-sibling::td)) + 1" as="xs:integer"/>
		<xsl:sequence select="$altova:TableIndexInfo/altova:Row[$altova:nRow]/altova:ColumnIndex[$altova:nCell]"/>
	</xsl:function>
	<xsl:template match="@*" mode="altova:copy-table-cell-properties">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="@colspan" mode="altova:copy-table-cell-properties"/>
	<xsl:function name="altova:col-span" as="xs:integer">
		<xsl:param name="altova:cell" as="element()"/>
		<xsl:sequence select="if ( exists( $altova:cell/@colspan ) ) then xs:integer( $altova:cell/@colspan ) else 1"/>
	</xsl:function>
	<xsl:template match="@* | node()" mode="altova:generate-table">
		<xsl:param name="altova:generate-cols"/>
		<xsl:param name="altova:TableIndexInfo"/>
		<xsl:copy>
			<xsl:apply-templates select="@* | node()" mode="#current">
				<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
				<xsl:with-param name="altova:TableIndexInfo" select="$altova:TableIndexInfo"/>
			</xsl:apply-templates>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="tbody" mode="altova:generate-table">
		<xsl:param name="altova:generate-cols"/>
		<xsl:param name="altova:TableIndexInfo"/>
		<xsl:choose>
			<xsl:when test="empty(tr)">
				<xsl:copy>
					<tr>
						<td/>
					</tr>
				</xsl:copy>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@* | node()" mode="#current">
						<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
						<xsl:with-param name="altova:TableIndexInfo" select="$altova:TableIndexInfo"/>
					</xsl:apply-templates>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="tr" mode="altova:generate-table">
		<xsl:param name="altova:generate-cols"/>
		<xsl:param name="altova:TableIndexInfo"/>
		<xsl:choose>
			<xsl:when test="ancestor::table[1]/@altova:hide-rows = 'empty'">
				<xsl:if test="some $altova:cell in (th | td) satisfies not(altova:is-cell-empty($altova:cell))">
					<xsl:copy>
						<xsl:apply-templates select="@* | node()" mode="#current">
							<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
							<xsl:with-param name="altova:TableIndexInfo" select="$altova:TableIndexInfo"/>
						</xsl:apply-templates>
					</xsl:copy>
				</xsl:if>
			</xsl:when>
			<xsl:when test="ancestor::table[1]/@altova:hide-rows = 'body-empty'">
				<xsl:if test="not(exists(parent::tbody)) or (some $altova:cell in td satisfies not(altova:is-cell-empty($altova:cell)))">
					<xsl:copy>
						<xsl:apply-templates select="@* | node()" mode="#current">
							<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
							<xsl:with-param name="altova:TableIndexInfo" select="$altova:TableIndexInfo"/>
						</xsl:apply-templates>
					</xsl:copy>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@* | node()" mode="#current">
						<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
						<xsl:with-param name="altova:TableIndexInfo" select="$altova:TableIndexInfo"/>
					</xsl:apply-templates>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="th | td" mode="altova:generate-table">
		<xsl:param name="altova:generate-cols"/>
		<xsl:param name="altova:TableIndexInfo"/>
		<xsl:variable name="altova:this-cell" select="."/>
		<xsl:variable name="altova:col-index" select="altova:col-position($altova:this-cell, $altova:TableIndexInfo)"/>
		<xsl:choose>
			<xsl:when test="$altova:generate-cols[$altova:col-index]">
				<xsl:copy>
					<xsl:apply-templates select="@*" mode="#current">
						<xsl:with-param name="altova:generate-cols" select="$altova:generate-cols"/>
						<xsl:with-param name="altova:TableIndexInfo" select="$altova:TableIndexInfo"/>
					</xsl:apply-templates>
					<xsl:choose>
						<xsl:when test="altova:is-cell-empty($altova:this-cell)">
							<xsl:text>&#160;</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:copy-of select="node()"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="altova:col-span($altova:this-cell) > 1">
				<xsl:for-each select="for $altova:pos in $altova:col-index to ($altova:col-index + altova:col-span($altova:this-cell) - 1) return if ($altova:generate-cols[$altova:pos]) then true() else ()">
					<xsl:for-each select="$altova:this-cell">
						<xsl:copy>
							<xsl:apply-templates select="@*" mode="altova:copy-table-cell-properties"/>
							<xsl:text>&#160;</xsl:text>
						</xsl:copy>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="@colspan" mode="altova:generate-table">
		<xsl:param name="altova:generate-cols"/>
		<xsl:param name="altova:TableIndexInfo"/>
		<xsl:choose>
			<xsl:when test="exists( ancestor::table[ 1 ]/@altova:hide-cols )">
				<xsl:variable name="altova:col-index" select="altova:col-position(.., $altova:TableIndexInfo)"/>
				<xsl:attribute name="colspan" select="sum( for $altova:pos in $altova:col-index to ( $altova:col-index + xs:integer( . ) - 1 ) return if ( $altova:generate-cols[ $altova:pos ] ) then 1 else 0 )"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="colspan" select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="@altova:hide-rows | @altova:hide-cols" mode="altova:generate-table"/>
	<xsl:function name="altova:CountLeadingTrueValues">
		<xsl:param name="seqBools"/>
		<xsl:sequence select="if (not($seqBools[1] = true())) then 0 else 1 + altova:CountLeadingTrueValues($seqBools[position() gt 1])"/>
	</xsl:function>
	<xsl:function name="altova:GetCellFromRow" as="node()?">
		<xsl:param name="nodeTableRow" as="node()"/>
		<xsl:param name="nCell" as="xs:integer"/>
		<xsl:sequence select="$nodeTableRow/(th | td)[$nCell]"/>
	</xsl:function>
	<xsl:function name="altova:GetCellsFromRow" as="node()*">
		<xsl:param name="nodeTableRow" as="node()"/>
		<xsl:sequence select="$nodeTableRow/(th | td)"/>
	</xsl:function>
	<xsl:function name="altova:GetRowsFromTable" as="node()*">
		<xsl:param name="nodeTable" as="node()"/>
		<xsl:sequence select="$nodeTable/(thead | tbody | tfoot)/tr"/>
	</xsl:function>
	<xsl:function name="altova:GetRowspanFromCell" as="xs:integer">
		<xsl:param name="altova:nodeCell" as="node()"/>
		<xsl:variable name="altova:sRowSpan" select="$altova:nodeCell/@rowspan" as="xs:string?"/>
		<xsl:variable name="altova:nRowSpan" select="if ($altova:sRowSpan) then xs:integer($altova:sRowSpan) else 1" as="xs:integer"/>
		<xsl:sequence select="$altova:nRowSpan"/>
	</xsl:function>
	<!-- In HTML and FO, the table section order is header, footer, body. This function determines, for a given cell, the number its row would have if the section order were header, body, footer -->
	<xsl:function name="altova:GetGridRowNumForCell">
		<xsl:param name="altova:nodeTableCell" as="node()"/>
		<xsl:variable name="altova:nodeTableRow" select="$altova:nodeTableCell/.." as="node()"/>
		<xsl:variable name="altova:nodeTableSection" select="$altova:nodeTableRow/.." as="node()"/>
		<xsl:variable name="altova:sTableSection" select="fn:local-name($altova:nodeTableSection)" as="xs:string"/>
		<xsl:variable name="altova:nodeTable" select="$altova:nodeTableSection/.." as="node()"/>
		<xsl:variable name="altova:nRowNumInSection" select="count($altova:nodeTableRow/preceding-sibling::tr) + 1" as="xs:integer"/>
		<xsl:choose>
			<xsl:when test="$altova:sTableSection eq 'tbody'">
				<xsl:sequence select="count($altova:nodeTable/thead/tr) + $altova:nRowNumInSection"/>
			</xsl:when>
			<xsl:when test="$altova:sTableSection eq 'thead'">
				<xsl:sequence select="$altova:nRowNumInSection"/>
			</xsl:when>
			<xsl:when test="$altova:sTableSection eq 'tfoot'">
				<xsl:sequence select="count($altova:nodeTable/thead/tr) + count($altova:nodeTable/tbody/tr) + $altova:nRowNumInSection"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message select="'Internal Error'" terminate="yes"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<xsl:function name="altova:BuildTableIndexInfo" as="node()">
		<xsl:param name="altova:nodeTable" as="node()"/>
		<altova:ColumnIndices>
			<xsl:variable name="altova:nodeAllRows" select="altova:GetRowsFromTable($altova:nodeTable/table)" as="node()*"/>
			<xsl:variable name="altova:seqCellsInFirstRow" select="altova:GetCellsFromRow($altova:nodeAllRows[1])" as="node()*"/>
			<xsl:variable name="altova:nColumnsInTable" select="sum(for $nodeCell in $altova:seqCellsInFirstRow return altova:col-span($nodeCell))" as="xs:integer"/>
			<xsl:variable name="altova:seqActiveRowSpans" select="for $Cell in 1 to $altova:nColumnsInTable return 0" as="xs:integer*"/>
			<xsl:sequence select="altova:BuildTableIndexInfo_Recursive($altova:nodeAllRows, 1, $altova:seqActiveRowSpans)"/>
		</altova:ColumnIndices>
	</xsl:function>
	<xsl:function name="altova:BuildTableIndexInfo_Recursive" as="node()*">
		<xsl:param name="altova:nodeTableRows" as="node()*"/>
		<xsl:param name="altova:nRow" as="xs:integer"/>
		<xsl:param name="altova:seqActiveRowSpans" as="xs:integer*"/>
		<xsl:variable name="altova:nodeRow" select="$altova:nodeTableRows[$altova:nRow]" as="node()?"/>
		<xsl:choose>
			<xsl:when test="empty($altova:nodeRow)">
				<xsl:sequence select="()"/>
			</xsl:when>
			<xsl:when test="empty(altova:GetCellFromRow($altova:nodeRow, 1))">
				<xsl:sequence select="()"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="altova:nodeCell1" select="altova:GetCellFromRow($altova:nodeRow, 1)" as="node()?"/>
				<xsl:variable name="altova:nColSpan" select="altova:col-span($altova:nodeCell1)" as="xs:integer"/>
				<altova:Row>
					<xsl:variable name="altova:seqColumnIndicesOfCurrentRow" select="altova:BuildTableIndexInfo_SingleRow_Recursive($altova:seqActiveRowSpans, $altova:nodeRow, 1, 1, $altova:nColSpan, true(), 0, 0)" as="node()*"/>
					<xsl:sequence select="$altova:seqColumnIndicesOfCurrentRow"/>
				</altova:Row>
				<xsl:variable name="altova:seqActiveRowSpans_New" select="altova:BuildTableIndexInfo_ActiveRowSpans_Recursive($altova:seqActiveRowSpans, $altova:nodeRow, 1, 1, $altova:nColSpan)" as="xs:integer*"/>
				<xsl:sequence select="altova:BuildTableIndexInfo_Recursive($altova:nodeTableRows, $altova:nRow + 1, $altova:seqActiveRowSpans_New)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<xsl:function name="altova:BuildTableIndexInfo_SingleRow_Recursive" as="node()*">
		<xsl:param name="altova:seqActiveRowSpans" as="xs:integer*"/>
		<xsl:param name="altova:nodeRow" as="node()"/>
		<xsl:param name="altova:nColumn" as="xs:integer"/>
		<xsl:param name="altova:nCellInCurrentRow" as="xs:integer"/>
		<xsl:param name="altova:nColSpanInCellRemaining" as="xs:integer"/>
		<xsl:param name="altova:bColSpanBegins" as="xs:boolean"/>
		<!-- Also true if it's just a single cell -->
		<xsl:param name="altova:nCurrentSum" as="xs:integer"/>
		<xsl:param name="altova:nRowSpansToAdd" as="xs:integer"/>
		<xsl:choose>
			<xsl:when test="$altova:nColumn gt count($altova:seqActiveRowSpans)">
				<xsl:sequence select="()"/>
			</xsl:when>
			<!-- If the cell is not under a rowspan -->
			<xsl:when test="$altova:seqActiveRowSpans[$altova:nColumn] eq 0">
				<!-- If the cell is not under a colspan -->
				<xsl:if test="$altova:bColSpanBegins eq true()">
					<!-- A non-spanned cell starts in this column -->
					<altova:ColumnIndex>
						<xsl:sequence select="$altova:nCurrentSum + 1"/>
					</altova:ColumnIndex>
				</xsl:if>
				<xsl:variable name="altova:nCellInCurrentRow_New" select="if ($altova:nColSpanInCellRemaining gt 1) then $altova:nCellInCurrentRow else $altova:nCellInCurrentRow + 1" as="xs:integer"/>
				<xsl:variable name="altova:nColSpanInCell_New" select="if ($altova:nColSpanInCellRemaining gt 1) then $altova:nColSpanInCellRemaining - 1 else if (empty(altova:GetCellFromRow($altova:nodeRow, $altova:nCellInCurrentRow_New))) then 1 else altova:col-span(altova:GetCellFromRow($altova:nodeRow, $altova:nCellInCurrentRow_New))" as="xs:integer"/>
				<xsl:variable name="altova:bColSpanBegins_New" select="$altova:nCellInCurrentRow ne $altova:nCellInCurrentRow_New" as="xs:boolean"/>
				<xsl:sequence select="altova:BuildTableIndexInfo_SingleRow_Recursive($altova:seqActiveRowSpans, $altova:nodeRow, $altova:nColumn + 1, $altova:nCellInCurrentRow_New, $altova:nColSpanInCell_New, $altova:bColSpanBegins_New, $altova:nCurrentSum + 1, $altova:nRowSpansToAdd)"/>
			</xsl:when>
			<!-- The cell is under a rowspan -->
			<xsl:otherwise>
				<xsl:sequence select="altova:BuildTableIndexInfo_SingleRow_Recursive($altova:seqActiveRowSpans, $altova:nodeRow, $altova:nColumn + 1, $altova:nCellInCurrentRow, $altova:nColSpanInCellRemaining, $altova:bColSpanBegins, $altova:nCurrentSum + 1, $altova:nRowSpansToAdd + 1)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<xsl:function name="altova:BuildTableIndexInfo_ActiveRowSpans_Recursive" as="xs:integer*">
		<xsl:param name="altova:seqRowSpans" as="xs:integer*"/>
		<xsl:param name="altova:nodeCurrentRow" as="node()"/>
		<xsl:param name="altova:nColumn" as="xs:integer"/>
		<xsl:param name="altova:nCellInCurrentRow" as="xs:integer"/>
		<xsl:param name="altova:nColSpanInCellRemaining" as="xs:integer"/>
		<xsl:choose>
			<xsl:when test="$altova:nColumn gt count($altova:seqRowSpans)">
				<xsl:sequence select="()"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="altova:nRowSpanForCurrentColumn" select="altova:BuildTableIndexInfo_ActiveRowSpans_SingleColumn($altova:seqRowSpans, $altova:nodeCurrentRow, $altova:nColumn, $altova:nCellInCurrentRow)" as="xs:integer?"/>
				<xsl:sequence select="$altova:nRowSpanForCurrentColumn"/>
				<xsl:variable name="altova:nCellInCurrentRow_New" select="if ($altova:seqRowSpans[$altova:nColumn] eq 0 and $altova:nColSpanInCellRemaining eq 1) then $altova:nCellInCurrentRow + 1 else $altova:nCellInCurrentRow" as="xs:integer"/>
				<xsl:variable name="altova:nColSpanInCell_New" select="if ($altova:seqRowSpans[$altova:nColumn] eq 0 and $altova:nCellInCurrentRow eq $altova:nCellInCurrentRow_New) then $altova:nColSpanInCellRemaining - 1 else if (empty(altova:GetCellFromRow($altova:nodeCurrentRow, $altova:nCellInCurrentRow_New))) then 1 else altova:col-span(altova:GetCellFromRow($altova:nodeCurrentRow, $altova:nCellInCurrentRow_New))" as="xs:integer"/>
				<xsl:variable name="altova:seqRowSpansForFollowingColumns" select="altova:BuildTableIndexInfo_ActiveRowSpans_Recursive($altova:seqRowSpans, $altova:nodeCurrentRow, $altova:nColumn + 1, $altova:nCellInCurrentRow_New, $altova:nColSpanInCell_New)" as="xs:integer*"/>
				<xsl:sequence select="$altova:seqRowSpansForFollowingColumns"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<xsl:function name="altova:BuildTableIndexInfo_ActiveRowSpans_SingleColumn" as="xs:integer?">
		<xsl:param name="altova:seqRowSpans" as="xs:integer*"/>
		<xsl:param name="altova:nodeCurrentRow" as="node()"/>
		<xsl:param name="altova:nColumn" as="xs:integer"/>
		<xsl:param name="altova:nCellInCurrentRow" as="xs:integer"/>
		<xsl:choose>
			<xsl:when test="$altova:seqRowSpans[$altova:nColumn] gt 0">
				<xsl:sequence select="$altova:seqRowSpans[$altova:nColumn] - 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="altova:nodeCell" select="altova:GetCellFromRow($altova:nodeCurrentRow, $altova:nCellInCurrentRow)" as="node()"/>
				<xsl:variable name="altova:nRowSpan" select="altova:GetRowspanFromCell($altova:nodeCell) - 1" as="xs:integer"/>
				<xsl:sequence select="$altova:nRowSpan"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<xsl:function name="altova:GetChartYValuesForSingleSeries">
		<xsl:param name="seqCategoryLeafPos" as="node()*"/>
		<xsl:param name="nodeSeriesLeafPos" as="node()"/>
		<xsl:param name="bValuesInCategory" as="xs:boolean"/>
		<xsl:for-each select="$seqCategoryLeafPos">
			<xsl:element name="altova:Value">
				<xsl:value-of select="altova:GetChartYValueForSingleSeriesPos($nodeSeriesLeafPos, ., $bValuesInCategory)"/>
			</xsl:element>
		</xsl:for-each>
	</xsl:function>
	<xsl:function name="altova:GetChartYValueForSingleSeriesPos">
		<xsl:param name="nodeSeriesLeafPos" as="node()"/>
		<xsl:param name="nodeCategoryLeafPos" as="node()"/>
		<xsl:param name="bValuesInCategory" as="xs:boolean"/>
		<xsl:variable name="altova:seqCategoryContextIds" select="$nodeCategoryLeafPos/altova:Context/@altova:ContextId" as="xs:string*"/>
		<xsl:variable name="altova:seqSeriesContextIds" select="$nodeSeriesLeafPos/altova:Context/@altova:ContextId" as="xs:string*"/>
		<xsl:variable name="altova:sCommonContextId" select="for $i in $altova:seqCategoryContextIds return if (some $j in $altova:seqSeriesContextIds satisfies $i eq $j) then $i else ()" as="xs:string*"/>
		<xsl:choose>
			<xsl:when test="count($altova:sCommonContextId) gt 1">
				<xsl:message select="concat('Es wurden mehrere Werte anstatt eines einzigen gefunden (Contexts: ', string-join($altova:sCommonContextId, ', '), ').')" terminate="yes"/>
			</xsl:when>
			<xsl:when test="count($altova:sCommonContextId) lt 1">
				<xsl:message select="concat('XBRL Chart: Info: No value found for position labeled &quot;', $nodeCategoryLeafPos/@altova:sLabel, '&quot;')" terminate="no"/>
				<xsl:sequence select="'altova:no-value'"/>
			</xsl:when>
			<xsl:when test="$bValuesInCategory">
				<xsl:sequence select="xs:string($nodeCategoryLeafPos/altova:Context[@altova:ContextId eq $altova:sCommonContextId]/@altova:Value)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:sequence select="xs:string($nodeSeriesLeafPos/altova:Context[@altova:ContextId eq $altova:sCommonContextId]/@altova:Value)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<xsl:function name="altova:GetChartLabelForPos" as="xs:string">
		<xsl:param name="nodeParam" as="node()"/>
		<xsl:value-of select="string-join($nodeParam/ancestor-or-self::altova:Pos/@altova:sLabel, ' ')"/>
	</xsl:function>
	<xsl:function name="altova:convert-length-to-pixel" as="xs:decimal">
		<xsl:param name="altova:length"/>
		<xsl:variable name="normLength" select="normalize-space($altova:length)"/>
		<xsl:choose>
			<xsl:when test="ends-with($normLength, 'px')">
				<xsl:value-of select="substring-before($normLength, 'px')"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'in')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'in')) * $altova:nPxPerIn"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'cm')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'cm')) * $altova:nPxPerIn div 2.54"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'mm')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'mm')) * $altova:nPxPerIn div 25.4"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'pt')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'pt')) * $altova:nPxPerIn div 72.0"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'pc')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'pc')) * $altova:nPxPerIn div 6.0"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$normLength"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<xsl:function name="altova:convert-length-to-mm" as="xs:decimal">
		<xsl:param name="altova:length"/>
		<xsl:variable name="normLength" select="normalize-space($altova:length)"/>
		<xsl:choose>
			<xsl:when test="ends-with($normLength, 'px')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'px')) div $altova:nPxPerIn * 25.4"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'in')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'in')) * 25.4"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'cm')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'cm')) * 10"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'mm')">
				<xsl:value-of select="substring-before($normLength, 'mm') "/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'pt')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'pt')) * 25.4 div 72.0"/>
			</xsl:when>
			<xsl:when test="ends-with($normLength, 'pc')">
				<xsl:value-of select="xs:decimal(substring-before($normLength, 'pc')) * 25.4 div 6.0"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="number($normLength) div $altova:nPxPerIn * 25.4"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
</xsl:stylesheet>
