// DO NOT CHANGE THIS DOCUMENT BECAUSE IT CAN GET OVERWRITTEN BY ONLINE-UPDATE!
//
// Usage in MLXML Document:
// Use this functions as tag or node content: @{GetXXXX@$APP$mlxml\scripts\utils1.pas}
//
// Example for GetDefaultValueIfEmpty: <address name="Peter" surname="Muster" acomment="@{GetDefaultValueIfEmpty('acomment', 'no comment :)')@$APP$mlxml\scripts\utils1.pas}" />
// Example for GetFirstOrSecondValue: <address name="Peter" surname="Muster" acomment="@{GetFirstOrSecondValue('acomment', 'acomment2')@$APP$mlxml\scripts\utils1.pas}" />

// Returns the value in AEmptyValue if value in field AFieldName is empty - else it returns value in AFieldName
function GetDefaultValueIfEmpty(const Data: TXMLDataWrapper; AFieldName: String;
  AEmptyValue: String = 'Default'): Variant;
begin
  if Length(Trim(Data.ValueByName(AFieldName))) > 0 then
    Result := Data.ValueByName(AFieldName)
  else
    Result := AEmptyValue;
end;

// Return the value in field AFieldName1 if not empty, else value in AFieldName2 if not empty, else return AEmptyValue
function GetFirstOrSecondValue(const Data: TXMLDataWrapper;
  AFieldName1, AFieldName2: String; AEmptyValue: String = ''): Variant;
begin
  if Length(Trim(Data.ValueByName(AFieldName1))) > 0 then
    Result := Data.ValueByName(AFieldName1)
  else if Length(Trim(Data.ValueByName(AFieldName2))) > 0 then
    Result := Data.ValueByName(AFieldName2)
  else
    Result := AEmptyValue;
end;

// Change the sign of a number
// @{GetNegativeValue('fieldname')@$APP$mlxml\scripts\utils1.pas}
function GetNegativeValue(const Data: TXMLDataWrapper;
  AFieldName: String): Variant;
var
  d: double;
begin
  d := Data.ValueByName(AFieldName, wctFloat);
  Result := -d;
end;

// @{GetCurrentDateTime@$APP$mlxml\scripts\utils1.pas}
function GetCurrentDateTime(const Data: TXMLDataWrapper): Variant;
begin
  Result := Now;
end;

// @{GetMultipleFieldsCombinedValue('checkfieldxy_')@$APP$mlxml\scripts\utils1.pas}
function GetMultipleFieldsCombinedValue(const Data: TXMLDataWrapper;
  AFieldNamePattern: String): Variant;
var
  i: Integer;
  List: TStringList;
begin
  List := TStringList.Create;
  try
    List.Delimiter := ';';
    List.StrictDelimiter := true;

    for i := 0 to Data.Count - 1 do
    begin
      if StrLike(Data.Names[i], AFieldNamePattern) then
      begin
        List.Add(Data.Values[i]);
      end;
    end;

    Result := List.DelimitedText;
  finally
    List.Free;
  end;
end;

// @{GetMultipleFieldsDefinedValue('checkfieldxy_')@$APP$mlxml\scripts\utils1.pas}
function GetMultipleFieldsDefinedValue(const Data: TXMLDataWrapper;
  AFieldNamePattern: String): Variant;
var
  i: Integer;
begin
  Result := Null;

  for i := 0 to Data.Count - 1 do
  begin
    if StrLike(Data.Names[i], AFieldNamePattern) then
    begin
      if Length(Data.Values[i]) > 0 then
      begin
        Result := Data.Values[i];
      end;
    end;
  end;
end;

// Returns a LookupValue Content to Lookup multiple fields. AMustKeyFields contains keyfields who must be the same. AOptionalKeyFields contains keyfields who only get take into account if a value is supplied
// Example usage:
// ownerid--sourcefield=companyname,name,surname,birthday
// ownerid--sourcefieldmode=and|
// ownerid=@{GetCombinedLookupKeyValue('companyname', 'name;surname;birthday')@$APP$mlxml\scripts\utils1.pas}
function GetCombinedLookupKeyValue(const Data: TXMLDataWrapper;
  AMustKeyFields, AOptionalKeyFields: String): Variant;
var
  i: Integer;
  ResultList, List: TStringList;
begin
  ResultList := TStringList.Create;
  List := TStringList.Create;
  try
    ResultList.Delimiter := '|';
    ResultList.StrictDelimiter := true;

    List.Delimiter := ';';
    List.StrictDelimiter := true;

    List.DelimitedText := AMustKeyFields;
    for i := 0 to List.Count - 1 do
    begin
      ResultList.Add(List[i] + '=' + Data.ValueByName(List[i]));
    end;

    List.DelimitedText := AOptionalKeyFields;
    for i := 0 to List.Count - 1 do
    begin
      if Trim(Data.ValueByName(List[i])) <> '' then
      begin
        ResultList.Add(List[i] + '=' + Data.ValueByName(List[i]));
      end;
    end;

    Result := ResultList.DelimitedText;
  finally
    List.Free;
    ResultList.Free;
  end;
end;

// @{GetMappedValueList('categories', '$APP$mlxml\mymapfile.txt', '', '\')@$APP$mlxml\scripts\utils1.pas}
function GetMappedValueList(const Data: TXMLDataWrapper;
  AFieldName, AMappingFile, ASourceDelimiter, ADestDelimiter: String): Variant;
var
  i: Integer;
  ResultList, List, MappingData: TStringList;
begin
  ResultList := TStringList.Create;
  List := TStringList.Create;
  MappingData := TStringList.Create;
  try
    AMappingFile := StringReplace(AMappingFile, '$APP$',
      ExtractFilePath(ParamStr(0)));
    MappingData.LoadFromFile(AMappingFile);

    if ADestDelimiter <> '' then
      ResultList.Delimiter := ADestDelimiter
    else
      ResultList.Delimiter := ',';
    ResultList.StrictDelimiter := true;

    if ASourceDelimiter <> '' then
      List.Delimiter := ASourceDelimiter
    else
      List.Delimiter := ',';
    List.StrictDelimiter := true;

    List.DelimitedText := Trim(Data.ValueByName(AFieldName));
    for i := 0 to List.Count - 1 do
    begin
      ResultList.Add(MappingData.Values[List[i]]);
    end;

    Result := ResultList.DelimitedText;
  finally
    List.Free;
    ResultList.Free;
    MappingData.Free;
  end;
end;

// @{GetIsEmptyValue('fieldname')@$APP$mlxml\scripts\utils1.pas}
function GetIsEmptyValue(const Data: TXMLDataWrapper;
  AFieldName: String): Variant;
begin
  Result := Length(Data.ValueByName(AFieldName, wctString)) = 0;
end;

// @{GetIsNotEmptyValue('fieldname')@$APP$mlxml\scripts\utils1.pas}
function GetIsNotEmptyValue(const Data: TXMLDataWrapper;
  AFieldName: String): Variant;
begin
  Result := Length(Data.ValueByName(AFieldName, wctString)) > 0;
end;

// @{GetValueByFieldName('adrpro_addresses_det', 'berater-uid', 'agency_number', 'termin_agency', 1)@$APP$mlxml\scripts\utils1.pas}
function GetValueByFieldName(const Data: TXMLDataWrapper;
  const ASchemaName, AFieldNames, AMappedNames, AResultFieldName: String;
  const AIsLookUp, AAllowEmptyDataFields: Boolean): Variant;
var
  i: Integer;
  RS: TMLRecordSet;
  FieldNameList, MappedNameList: TStringList;
begin
  FieldNameList := TStringList.Create;
  try
    FieldNameList.Delimiter := ';';
    FieldNameList.StrictDelimiter := true;
    FieldNameList.DelimitedText := AFieldNames;
	
    MappedNameList := TStringList.Create;
    try
      MappedNameList.Delimiter := ';';
      MappedNameList.StrictDelimiter := true;
      MappedNameList.DelimitedText := AMappedNames;
	  
      RS := TMLRecordSet.Create(ScriptingHost);
      try
        RS.SchemaName := ASchemaName;
        RS.LoadAfterShow := false;
        RS.LoadAllFields := false;
        RS.SelectFields.Add(AResultFieldName);

        for i := 0 to FieldNameList.Count - 1 do
        begin
          if (Trim(Data.ValueByName(MappedNameList[i])) = '') and
            (not AAllowEmptyDataFields) then
          begin
            Result := Null;
            Exit;
          end;

          RS.Filters.AddFilter(FieldNameList[i], Data.ValueByName(MappedNameList[i]));
        end;

        RS.Refresh(true);
		
        if RS.RecordCount > 0 then
        begin
          if AIsLookUp then
          begin
            if RS.ValueByName(0, AResultFieldName).RealValue > 0 then
              Result := RS.ValueByName(0, AResultFieldName).RealValue
            else
              Result := Null;
          end
          else
            Result := RS.ValueByName(0, AResultFieldName).AsVariant;
        end
        else
          Result := Null;
      finally
        RS.Free;
      end;
    finally
      MappedNameList.Free;
    end;
  finally
    FieldNameList.Free;
  end;
end;

begin

end.