// DO NOT CHANGE THIS DOCUMENT BECAUSE IT CAN GET OVERWRITTEN BY ONLINE-UPDATE!
//
// Usage in MLXML Document:
// Use this value as tag or node content: @{GetTemplateContent@$APP$mlxml\scripts\contenttemplate.pas}
// Place the Template (eg. a RTF or a TXT File - depending on the destination field) in a subdirectory of application (eg. mlxml\templates) and add
// this realtive path as contenttemplate attribute.
// Insiede the template you can use any value of the MLXML-Element as macros like [AttributeName]
//
// Example 1: <address name="Peter" surname="Muster" acomment="@{GetTemplateContent@$APP$mlxml\scripts\contenttemplate.pas}" contenttemplate="mlxml\templates\comment_template.txt" />
//   (supply template by node)
//
// Example 2: <address name="Peter" surname="Muster" acomment="@{GetTemplateContent('mlxml\templates\comment_template.txt')@$APP$mlxml\scripts\contenttemplate.pas}" />
//   (supply template by parameter to function)
//
// The content of "comment_template.txt" may look like this: "This is a comment on [name] [surname]"  

function GetTemplateContent(const Data: TXMLDataWrapper; AContentTemplate: String = ''): Variant;
var
  i: Integer;
  TemplateName, MacroName: String;
  MacroProcessor: DIMacroProcessor;
  TemplateData: TStringList;
begin
  MacroProcessor :=	CreateNewMacroProcessor;

  if Length(AContentTemplate) = 0 then
    TemplateName := ExtractFilePath(Application.ExeName) + Data.ValueByName('contenttemplate')
  else
    TemplateName := ExtractFilePath(Application.ExeName) + AContentTemplate;

  TemplateData := TStringList.Create;
  try
    TemplateData.LoadFromFile(TemplateName);
    MacroProcessor.Do_Start(TemplateData.Text);
	
    for i := 0 to Data.Count-1 do begin
      MacroName := '[' + Data.Names[i] + ']';
      if MacroProcessor.Get_HasMacro(MacroName) then begin
        MacroProcessor.Do_ReplaceMacroDataEx1(MacroName, Data.Values[i]);
      end;
    end;
	
	  MacroProcessor.Do_EmptyPendingMacros;
    Result := MacroProcessor.Get_RawContent;
  finally
    TemplateData.Free;
  end;
end;

begin
end.


